/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.castables;

import at.petrak.hexcasting.api.casting.arithmetic.engine.NoOperatorCandidatesException;
import at.petrak.hexcasting.api.casting.castables.Action;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.casting.mishaps.MishapInvalidOperatorArgs;
import at.petrak.hexcasting.common.lib.hex.HexArithmetics;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010\u0007\u00a8\u0006 "}, d2={"Lat/petrak/hexcasting/api/casting/castables/OperationAction;", "Lat/petrak/hexcasting/api/casting/castables/Action;", "Lat/petrak/hexcasting/api/casting/math/HexPattern;", "pattern", "<init>", "(Lat/petrak/hexcasting/api/casting/math/HexPattern;)V", "component1", "()Lat/petrak/hexcasting/api/casting/math/HexPattern;", "copy", "(Lat/petrak/hexcasting/api/casting/math/HexPattern;)Lat/petrak/hexcasting/api/casting/castables/OperationAction;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "Lat/petrak/hexcasting/api/casting/eval/vm/CastingImage;", "image", "Lat/petrak/hexcasting/api/casting/eval/vm/SpellContinuation;", "continuation", "Lat/petrak/hexcasting/api/casting/eval/OperationResult;", "operate", "(Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;Lat/petrak/hexcasting/api/casting/eval/vm/CastingImage;Lat/petrak/hexcasting/api/casting/eval/vm/SpellContinuation;)Lat/petrak/hexcasting/api/casting/eval/OperationResult;", "", "toString", "()Ljava/lang/String;", "Lat/petrak/hexcasting/api/casting/math/HexPattern;", "getPattern", "hexcasting-fabric-1.20.1"})
public final class OperationAction
implements Action {
    @NotNull
    private final HexPattern pattern;

    public OperationAction(@NotNull HexPattern pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.pattern = pattern;
    }

    @NotNull
    public final HexPattern getPattern() {
        return this.pattern;
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        OperationResult operationResult;
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
        try {
            OperationResult operationResult2 = HexArithmetics.getEngine().run(this.pattern, env, image, continuation);
            Intrinsics.checkNotNullExpressionValue((Object)operationResult2, (String)"{\n            HexArithme\u2026, continuation)\n        }");
            operationResult = operationResult2;
        }
        catch (NoOperatorCandidatesException e) {
            List<Iota> list = e.getArgs();
            Intrinsics.checkNotNullExpressionValue(list, (String)"e.args");
            throw new MishapInvalidOperatorArgs(list);
        }
        return operationResult;
    }

    @NotNull
    public final HexPattern component1() {
        return this.pattern;
    }

    @NotNull
    public final OperationAction copy(@NotNull HexPattern pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return new OperationAction(pattern);
    }

    public static /* synthetic */ OperationAction copy$default(OperationAction operationAction, HexPattern hexPattern, int n, Object object) {
        if ((n & 1) != 0) {
            hexPattern = operationAction.pattern;
        }
        return operationAction.copy(hexPattern);
    }

    @NotNull
    public String toString() {
        return "OperationAction(pattern=" + this.pattern + ")";
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OperationAction)) {
            return false;
        }
        OperationAction operationAction = (OperationAction)other;
        return Intrinsics.areEqual((Object)this.pattern, (Object)operationAction.pattern);
    }
}

